/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.property.base.VWConfigWebApplicationPanel;
import filenet.vw.toolkit.admin.property.service.VWConfigRuntimeOptionsPane;
import filenet.vw.toolkit.admin.property.service.VWConfigStatisticsPane;
import filenet.vw.toolkit.admin.property.service.VWDBExecutePanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VWConfigVWServicePropertyDialog
extends VWModalDialog
implements ActionListener {
    protected JTabbedPane m_tabbedPane = null;
    protected VWConfigStatisticsPane m_statisticsPane = null;
    protected VWConfigRuntimeOptionsPane m_runtimeOptionsPane = null;
    protected VWConfigWebApplicationPanel m_webApplicationPanel = null;
    protected VWDBExecutePanel m_dbExecutePanel = null;
    protected JLabel m_serviceLabel = null;
    protected JLabel m_service = null;
    protected JButton m_OKButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;
    protected VWConfigVWServiceNode m_sNode = null;
    protected VWAttributeInfo m_vwAttributeInfo = null;
    protected int m_nRetStatus = -1;
    protected Font m_boldFont = null;
    protected VWSystemAdministration m_sysAdmin = null;

    public VWConfigVWServicePropertyDialog(Frame parent, VWConfigVWServiceNode sNode) {
        super(parent);
        this.applyComponentOrientation(parent.getComponentOrientation());
        try {
            this.m_sNode = sNode;
            if (this.m_sNode != null) {
                this.m_sysAdmin = this.m_sNode.getSysAdmin();
            }
            this.setTitle(VWResource.VWServiceProperties);
            Dimension dim = VWStringUtils.stringToDimension("775,445");
            if (dim == null) {
                dim = new Dimension(775, 445);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            Font aFont = this.getFont();
            this.m_boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            Container mainContainer = this.getContentPane();
            mainContainer.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 1;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            mainContainer.add((Component)this.createTabPanel(parent), gbConst);
            gbConst.fill = 2;
            gbConst.weighty = 0.0;
            gbConst.weightx = 0.0;
            ++gbConst.gridy;
            mainContainer.add((Component)this.createButtonPanel(), gbConst);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_nRetStatus = 1;
            this.m_dbExecutePanel.cancelModification();
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            try {
                if (!(this.m_runtimeOptionsPane.update() && this.m_webApplicationPanel.update() && this.m_dbExecutePanel.update())) {
                    return;
                }
                this.m_sysAdmin.setAttributeInfo(this.m_vwAttributeInfo);
                this.m_sysAdmin.commit();
                this.m_nRetStatus = 0;
                this.setVisible(false);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc076.htm");
        }
    }

    public void releaseResources() {
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.removeAll();
            this.m_tabbedPane = null;
        }
        if (this.m_statisticsPane != null) {
            this.m_statisticsPane.releaseResources();
            this.m_statisticsPane = null;
        }
        if (this.m_runtimeOptionsPane != null) {
            this.m_runtimeOptionsPane.releaseResources();
            this.m_runtimeOptionsPane = null;
        }
        if (this.m_webApplicationPanel != null) {
            this.m_webApplicationPanel.releaseResources();
            this.m_webApplicationPanel = null;
        }
        if (this.m_dbExecutePanel != null) {
            this.m_dbExecutePanel.releaseResources();
            this.m_dbExecutePanel = null;
        }
        if (this.m_serviceLabel != null) {
            this.m_serviceLabel.removeAll();
            this.m_serviceLabel = null;
        }
        if (this.m_service != null) {
            this.m_service.removeAll();
            this.m_service = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_sNode = null;
        this.m_vwAttributeInfo = null;
        this.m_boldFont = null;
        this.removeAll();
    }

    protected JTabbedPane createTabPanel(Frame parent) {
        try {
            this.m_tabbedPane = new JTabbedPane();
            if (this.m_sNode != null) {
                this.m_tabbedPane.add(VWResource.General, this.createGeneralTab());
                this.m_runtimeOptionsPane = new VWConfigRuntimeOptionsPane(parent, this.m_sysAdmin, this.m_sNode.getSessionInfo());
                this.m_tabbedPane.add(VWResource.RuntimeOptions, this.m_runtimeOptionsPane);
                this.m_vwAttributeInfo = this.m_sysAdmin.getAttributeInfo();
                this.m_webApplicationPanel = new VWConfigWebApplicationPanel(this, this.m_vwAttributeInfo, this.m_sNode.getSessionInfo(), true);
                this.m_tabbedPane.add(VWResource.WebApplications, this.m_webApplicationPanel);
                this.m_dbExecutePanel = new VWDBExecutePanel(this, this.m_sysAdmin);
                this.m_tabbedPane.add(VWResource.DBExecuteConnections, this.m_dbExecutePanel);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_tabbedPane;
    }

    protected JPanel createGeneralTab() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 10, 10, 0);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            ImageIcon serviceIcon = VWImageLoader.createImageIcon("wf_service_32.gif");
            JLabel iconLabel = new JLabel(serviceIcon, 2);
            panel.add((Component)iconLabel, gbConst);
            gbConst.gridy = 1;
            gbConst.gridwidth = 0;
            gbConst.weightx = 1.0;
            panel.add(Box.createVerticalStrut(20), gbConst);
            gbConst.insets = new Insets(4, 10, 4, 4);
            gbConst.gridx = 0;
            gbConst.gridy = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 1;
            this.m_serviceLabel = new JLabel(VWResource.s_label.toString(VWResource.VWService));
            this.m_serviceLabel.setFont(this.m_boldFont);
            panel.add((Component)this.m_serviceLabel, gbConst);
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridx = 1;
            gbConst.gridwidth = 0;
            this.m_service = new JLabel(this.m_sNode.getServiceName());
            panel.add((Component)this.m_service, gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            panel.add(Box.createHorizontalStrut(100), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            panel.add((Component)this.m_OKButton, gbConst);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add((Component)this.m_cancelButton, gbConst);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            panel.add((Component)this.m_helpButton, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }
}

